<?php
class ControllerCommonFooter extends Controller {
	public function index() {
		$this->load->language('common/footer');

		$this->load->model('catalog/information');

		$data['informations'] = array();

		foreach ($this->model_catalog_information->getInformations() as $result) {
			if ($result['bottom']) {
				$data['informations'][] = array(
					'title' => $result['title'],
					'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
				);
			}
		}


            // Fetching scroll color and status settings
        $data['scroll_background_color'] = $this->config->get('scroll_background_color');
        $data['scroll_text_color'] = $this->config->get('scroll_text_color');
        $data['scroll_status'] = $this->config->get('scroll_status');
        
		$data['contact'] = $this->url->link('information/contact');
		$data['return'] = $this->url->link('account/return/add', '', true);
		$data['sitemap'] = $this->url->link('information/sitemap');
		$data['tracking'] = $this->url->link('information/tracking');
		$data['manufacturer'] = $this->url->link('product/manufacturer');
		$data['voucher'] = $this->url->link('account/voucher', '', true);
		$data['affiliate'] = $this->url->link('affiliate/login', '', true);
		$data['special'] = $this->url->link('product/special');
		$data['account'] = $this->url->link('account/account', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['newsletter'] = $this->url->link('account/newsletter', '', true);

		$data['powered'] = sprintf($this->language->get('text_powered'), $this->config->get('config_name'), date('Y', time()));

		// Whos Online
		if ($this->config->get('config_customer_online')) {
			$this->load->model('tool/online');

			if (isset($this->request->server['REMOTE_ADDR'])) {
				$ip = $this->request->server['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

			if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {
				$url = ($this->request->server['HTTPS'] ? 'https://' : 'http://') . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];
			} else {
				$url = '';
			}

			if (isset($this->request->server['HTTP_REFERER'])) {
				$referer = $this->request->server['HTTP_REFERER'];
			} else {
				$referer = '';
			}

			$this->model_tool_online->addOnline($ip, $this->customer->getId(), $url, $referer);
		}

		$data['scripts'] = $this->document->getScripts('footer');
		$data['styles'] = $this->document->getStyles('footer');
		

            

         if ($data['scroll_status'] == 1) {
            $data['scroll_button_display'] = 'block'; // Show the button if enabled in settings
        } else {
            $data['scroll_button_display'] = 'none'; // Hide the button if disabled
        }

        // Include custom CSS for the scroll-to-top button
        $data['scroll_button_css'] = "
        <style>
            #scrollToTop {
                position: fixed;
                bottom: 20px;
                right: 20px;
                display: {$data['scroll_button_display']};
                width: 40px; /* Equal width and height for circle */
                height: 40px;
                line-height: 50px; /* Center align text */
                background: {$data['scroll_background_color']}; /* Background color set from settings */
                color: {$data['scroll_text_color']}; /* Text color set from settings */
                border-radius: 50%; /* Circular shape */
                text-align: center;
                font-size: 20px;
                text-decoration: none;
                transition: all 0.3s ease;
                box-shadow: none; /* No border or space by default */
            }

            #scrollToTop:hover {
                background: #D32F2F; /* Red background on hover */
                box-shadow: 0 0 0 9px white, 0 0 0 11px #B71C1C; /* White space and red border on hover */
            }
        </style>";
        
		return $this->load->view('common/footer', $data);
	}
}
