<?php
class ControllerMarketplaceScroll extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('marketplace/scroll');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('scroll', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

        }

        

        $data['heading_title'] = $this->language->get('heading_title');
         $data['text_settings'] = $this->language->get('text_settings'); 
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['entry_background_color'] = $this->language->get('entry_background_color');
        $data['entry_text_color'] = $this->language->get('entry_text_color');
        $data['entry_status'] = $this->language->get('entry_status');  

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['button_save'] = $this->language->get('button_save');
         $data['button_restore_default'] = $this->language->get('button_restore_default');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'type=module&user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('marketplace/scroll', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('marketplace/scroll', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'type=module&user_token=' . $this->session->data['user_token'], true);

        if (isset($this->request->post['scroll_background_color'])) {
            $data['scroll_background_color'] = $this->request->post['scroll_background_color'];
        } elseif ($this->config->get('scroll_background_color') !== null) {
            $data['scroll_background_color'] = $this->config->get('scroll_background_color');
        } else {
            $data['scroll_background_color'] = '#000000'; // Default black
        }
        
        if (isset($this->request->post['scroll_text_color'])) {
            $data['scroll_text_color'] = $this->request->post['scroll_text_color'];
        } elseif ($this->config->get('scroll_text_color') !== null) {
            $data['scroll_text_color'] = $this->config->get('scroll_text_color');
        } else {
            $data['scroll_text_color'] = '#FFFFFF'; // Default white
        }
        

        if (isset($this->request->post['scroll_status'])) {
            $data['scroll_status'] = $this->request->post['scroll_status'];
        } elseif ($this->config->get('scroll_status') !== null) {
            $data['scroll_status'] = $this->config->get('scroll_status');
        } else {
            $data['scroll_status'] = 1; 
        }


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('marketplace/scroll', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'marketplace/scroll')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
}
