<?php echo $header; ?>
<?php echo $column_left; ?>
<div id="content">
  <div class="page-header">
    <div class="container-fluid">
      <div class="pull-right">
         <button type="button" id="restore_default" class="btn btn-warning"><?php echo $button_restore_default; ?></button>
        <button type="submit" form="form-scroll" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
        <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
      </div>
      <h1><?php echo $heading_title; ?></h1>
      <ul class="breadcrumb">
        <?php foreach ($breadcrumbs as $breadcrumb) { ?>
        <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
        <?php } ?>
      </ul>
    </div>
  </div>
  <div class="container-fluid">
    <?php if ($success) { ?>
    <div class="alert alert-success alert-dismissible"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
      <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
    <?php } ?>
    <div class="panel panel-default">
      <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_settings; ?></h3>
      </div>
      <div class="panel-body">
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-scroll" class="form-horizontal">
          <div class="form-group">
            <label class="col-sm-2 control-label" for="input-background-color"><?php echo $entry_background_color; ?></label>
            <div class="col-sm-10">
              <input type="color" name="scroll_background_color" value="<?php echo $scroll_background_color; ?>" placeholder="<?php echo $entry_background_color; ?>" id="input-background-color" class="form-control" />
            </div>
          </div>
          <div class="form-group">
            <label class="col-sm-2 control-label" for="input-text-color"><?php echo $entry_text_color; ?></label>
            <div class="col-sm-10">
              <input type="color" name="scroll_text_color" value="<?php echo $scroll_text_color; ?>" placeholder="<?php echo $entry_text_color; ?>" id="input-text-color" class="form-control" />
            </div>
          </div>
          <div class="form-group">
            <label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
            <div class="col-sm-10">
              <select name="scroll_status" id="input-status" class="form-control">
                <option value="1"<?php echo ($scroll_status == 1) ? ' selected="selected"' : ''; ?>><?php echo $text_enabled; ?></option>
                <option value="0"<?php echo ($scroll_status == 0) ? ' selected="selected"' : ''; ?>><?php echo $text_disabled; ?></option>
              </select>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function() {
    // Get the restore button element
    const restoreButton = document.getElementById('restore_default');
    if (restoreButton) {
        restoreButton.addEventListener('click', function() {
            // Reset the colors and status
            const backgroundColorInput = document.getElementById('input-background-color');
            const textColorInput = document.getElementById('input-text-color');
            const statusSelect = document.getElementById('input-status');

            // Set default colors and status
            if (backgroundColorInput) {
                backgroundColorInput.value = '#000000'; // Default black for background
            }
            if (textColorInput) {
                textColorInput.value = '#FFFFFF'; // Default white for text
            }
            if (statusSelect) {
                statusSelect.value = '1'; // Default enabled status
            }

            // Optionally, you can also display a success message
            alert('Defaults have been restored!');
        });
    }
});

</script>
<?php echo $footer; ?>
